/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWXMLSchemaTableModel;
import filenet.vw.toolkit.design.property.workflow.VWXMLSchemaValueDialog;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWXMLSchemaPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWTableActionListener {
    private VWToolbarBorder m_schemaNameToolbar = null;
    private VWTable m_schemaNameTable = null;
    private VWXMLSchemaTableModel m_xmlSchemaTableModel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWXMLSchemaValueDialog m_schemaValueDialog = null;

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int nRowIndex;
            this.stopEditing();
            if (event.getSource().equals(this.m_schemaNameToolbar) && (nRowIndex = this.m_schemaNameTable.getSelectedRow()) != -1) {
                switch (event.getID()) {
                    case 0x10000000: {
                        this.m_xmlSchemaTableModel.deleteItem(nRowIndex);
                        break;
                    }
                    case 64: {
                        this.m_xmlSchemaTableModel.copyItem(nRowIndex);
                        break;
                    }
                    case 32: {
                        this.displaySchemaValueDialog();
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        try {
            switch (event.getType()) {
                case -1: 
                case 1: {
                    int nRow = event.getLastRow();
                    if (nRow < 0) {
                        nRow = 0;
                    }
                    if (nRow > this.m_schemaNameTable.getRowCount() - 1) {
                        nRow = this.m_schemaNameTable.getRowCount() - 1;
                    }
                    if (nRow == this.m_schemaNameTable.getSelectedRow()) {
                        this.m_schemaNameTable.clearSelection();
                    }
                    this.m_schemaNameTable.setRowSelectionInterval(nRow, nRow);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        try {
            this.m_schemaNameToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_schemaNameToolbar.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_schemaNameTable.getSelectedRow();
            if (this.m_xmlSchemaTableModel != null && nRowIndex != -1) {
                int nRowCount = this.m_xmlSchemaTableModel.getRowCount();
                boolean bCanEditItem = this.m_xmlSchemaTableModel.canDeleteRow(nRowIndex);
                if (nRowIndex != nRowCount - 1) {
                    int nButtons = 64;
                    if (bCanEditItem) {
                        nButtons |= 0x10000020;
                    }
                    this.m_schemaNameToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_schemaNameToolbar.getClientPanel(), 1, nButtons));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                this.stopEditing();
            }
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls();
            this.reinitialize();
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        this.stopEditing();
        if (this.m_xmlSchemaTableModel != null) {
            this.m_xmlSchemaTableModel.reinitialize();
        }
        if (this.m_schemaNameTable != null) {
            this.m_schemaNameTable.clearSelection();
            this.m_schemaNameTable.setRowSelectionInterval(0, 0);
        }
    }

    protected void stopEditing() {
        if (this.m_schemaNameTable != null) {
            this.m_schemaNameTable.stopEditing();
        }
        if (this.m_schemaValueDialog != null) {
            this.m_schemaValueDialog.setVisible(false);
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_schemaNameToolbar != null) {
            this.m_schemaNameToolbar.removeToolbarBorderActionNotifier(this);
            this.m_schemaNameToolbar.releaseReferences();
            this.m_schemaNameToolbar = null;
        }
        if (this.m_schemaNameTable != null) {
            this.m_schemaNameTable.getSelectionModel().removeListSelectionListener(this);
            this.m_schemaNameTable = null;
        }
        if (this.m_xmlSchemaTableModel != null) {
            this.m_xmlSchemaTableModel.removeTableModelListener(this);
            this.m_xmlSchemaTableModel = null;
        }
        if (this.m_schemaValueDialog != null) {
            this.m_schemaValueDialog.setVisible(false);
            this.m_schemaValueDialog.releaseReferences();
            this.m_schemaValueDialog = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.5;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.createTablePanel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel createTablePanel() {
        try {
            TableColumn tcElement;
            this.m_schemaNameToolbar = new VWToolbarBorder(VWResource.s_xmlSchema, 0x10000060);
            this.m_schemaNameToolbar.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_schemaNameToolbar.getClientPanel(), 2, Integer.MAX_VALUE));
            this.m_schemaNameToolbar.addToolbarBorderActionNotifier(this);
            JPanel xmlSchemaNamePanel = this.m_schemaNameToolbar.getClientPanel();
            xmlSchemaNamePanel.setLayout(new BorderLayout());
            this.m_xmlSchemaTableModel = new VWXMLSchemaTableModel(this.m_authPropertyData);
            this.m_xmlSchemaTableModel.addTableModelListener(this);
            this.m_schemaNameTable = new VWTable(this.m_xmlSchemaTableModel);
            this.m_schemaNameTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_schemaNameTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            ListSelectionModel selModel = this.m_schemaNameTable.getSelectionModel();
            if (selModel != null) {
                selModel.setSelectionMode(0);
                selModel.addListSelectionListener(this);
            }
            if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_schemaNameTable.getColumnModel().getColumn(this.m_xmlSchemaTableModel.getActualColumnIndex(0))) != null) {
                tcElement.setMaxWidth(20);
                tcElement.setMinWidth(20);
            }
            if ((tcElement = this.m_schemaNameTable.getColumnModel().getColumn(this.m_xmlSchemaTableModel.getActualColumnIndex(2))) != null) {
                tcElement.setCellRenderer(new VWToolTipTableCellRenderer());
            }
            xmlSchemaNamePanel.add((Component)new JScrollPane(this.m_schemaNameTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_schemaNameToolbar;
    }

    private void displaySchemaValueDialog() {
        try {
            int nRowIndex = this.m_schemaNameTable.getSelectedRow();
            if (this.m_xmlSchemaTableModel != null && nRowIndex != -1) {
                boolean bCanEditItem = this.m_xmlSchemaTableModel.canDeleteRow(nRowIndex);
                String schemaName = (String)this.m_xmlSchemaTableModel.getValueAt(nRowIndex, 1);
                String schema = (String)this.m_xmlSchemaTableModel.getValueAt(nRowIndex, this.m_xmlSchemaTableModel.getActualColumnIndex(2));
                if (this.m_schemaValueDialog == null) {
                    this.m_schemaValueDialog = new VWXMLSchemaValueDialog(this.m_authPropertyData);
                }
                this.m_schemaValueDialog.reinitialize(schemaName, schema, bCanEditItem);
                this.m_schemaValueDialog.show();
                if (this.m_schemaValueDialog.getExitStatus() == 0) {
                    schema = this.m_schemaValueDialog.getSchema();
                    this.m_xmlSchemaTableModel.setValueAt(schema, nRowIndex, this.m_xmlSchemaTableModel.getActualColumnIndex(2));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

